package CH.ifa.draw.standard;


/**
 * SubstringMatcher provides functionality to match
 * Substrings. Matches are replaced directly with the replacementString.
 *
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
public class SubstringMatcher implements StringMatcher {
    private final String _replaceString;
    private final String _searchString;
    private int _lastPosition;

    public SubstringMatcher(String searchString, String replaceString) {
        this._searchString = searchString;
        this._replaceString = replaceString;
    }

    /**
     * @return the lastPosition
     */
    public int getLastPosition() {
        return _lastPosition;
    }

    /**
     * @param lastPosition the lastPosition to set
     */
    public void setLastPosition(int lastPosition) {
        this._lastPosition = lastPosition;
    }


    /**
     * True iff this.searchString is a substring of compareString.
     */
    @Override
    public boolean matches(String compareString, boolean ignoreCase) {
        boolean found = false;

        for (int i = 0; i < compareString.length() && !found; i++) {
            found = compareString
                .regionMatches(ignoreCase, i, _searchString, 0, _searchString.length());
            setLastPosition(i);
        }

        return found;
    }

    /**
     * True iff this.searchString is a substring of compareString
     * beginning at or after fromIndex.
     */
    public boolean matches(String compareString, int fromIndex, boolean ignoreCase) {
        boolean found = false;
        for (int i = fromIndex; i < compareString.length() && !found; i++) {
            found = compareString
                .regionMatches(ignoreCase, i, _searchString, 0, _searchString.length());
        }
        return found;
    }

    /** Replaces only the first occurrence of this.searchString
     * in compareString with this.replaceString. Ignores case.
     */
    @Override
    public String replacement(String compareString) {
        String s1 = null;
        String s2 = null;
        boolean found = false;
        final boolean ignoreCase = true;
        for (int i = 0; i < compareString.length() && !found; i++) {
            found = compareString
                .regionMatches(ignoreCase, i, _searchString, 0, _searchString.length());
            if (found) {
                s1 = compareString.substring(0, i);
                s2 = compareString.substring(i + _searchString.length());

            }
        }
        if (found) {
            return s1 + _replaceString + s2;
        } else {
            return compareString;
        }
    }

    /**
     * Replaces only the first occurrence of this.searchString in compareString
     * with this.replaceString, starting from fromIndex, so
     * that replacement(s, 0) is equivalent to replacement(s)
     * Ignores case.
     */
    public String replacement(String compareString, int fromIndex) {
        String s1 = null;
        String s2 = null;
        boolean found = false;
        final boolean ignoreCase = true;
        for (int i = fromIndex; i < compareString.length() && !found; i++) {
            found = compareString
                .regionMatches(ignoreCase, i, _searchString, 0, _searchString.length());
            if (found) {
                s1 = compareString.substring(0, i);
                s2 = compareString.substring(i + _searchString.length());

            }
        }

        if (found) {
            return s1 + _replaceString + s2;
        } else {
            return compareString;
        }
    }

    /**
     * Like the indexOf Method of String, but ignores case
     */
    public int indexOf(String compareString, int fromIndex) {
        final boolean ignoreCase = true;
        for (int i = fromIndex; i < compareString.length(); i++) {
            if (compareString
                .regionMatches(ignoreCase, i, _searchString, 0, _searchString.length())) {
                return i;
            }
        }
        return -1;
    }

    /**
     * returns the Search String
     */
    public String getSearchString() {
        return _searchString;
    }

    /**
     * returns the Replace String
     */
    public String getReplaceString() {
        return _replaceString;
    }
}