/*
 * @(#)ToggleGridCommand.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.util.Properties;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.GUIProperties;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.PointConstrainer;
import de.renew.plugin.PluginProperties;


/**
 * A command to toggle the snap to grid behavior.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
public class ToggleGridCommand extends AbstractCommand {

    protected DrawingEditor getEditor() {
        return EditorApi.getCurrentEditor();
    }

    /**
     * Constructs a toggle grid command.
     * @param name the command name
     */
    public ToggleGridCommand(String name) {
        super(name);
    }

    @Override
    public boolean isExecutable() {
        if (getEditor() == EditorApi.getNullDrawingEditor()) {
            return false;
        }
        return super.isExecutable();
    }

    @Override
    public void execute() {
        DrawingView view = getEditor().view();
        PointConstrainer grid = view.getConstrainer();
        if (grid != null) {
            view.setConstrainer(null);
        } else {
            int size;
            DrawPlugin current = DrawPlugin.getCurrent();
            if (current == null) {
                Properties properties = GUIProperties.getProperties();
                size = ((PluginProperties) properties)
                    .getIntProperty(DrawPlugin.CH_IFA_DRAW_GRID_SIZE, 5);
            } else {
                size = current.getProperties().getIntProperty(DrawPlugin.CH_IFA_DRAW_GRID_SIZE, 5);
            }
            view.setConstrainer(new GridConstrainer(size, size));
        }
    }
}