/*
 * Created on 28.01.2004
 *
 */

package CH.ifa.draw.util;

import java.awt.Toolkit;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import de.renew.draw.ui.ontology.AbstractCommand;


/**
 * This class represents a JMenuItem that knows a Command to be triggered
 * if the item is selected by the user.
 *
 * @author Jörn Schumacher
 */
public class CommandMenuItem extends JMenuItem {

    /**
     * Holds the reference to the associated <code>Command</code>.
     **/
    private AbstractCommand _cmd;

    /**
     * Creates a new <code>CommandMenuItem</code> associated with
     * the given command.
     *
     * @param cmd  the associated <code>Command</code>
     **/
    public CommandMenuItem(AbstractCommand cmd) {
        super(cmd.getCommandName());
        this._cmd = cmd;
    }

    /**
     * Creates a new <code>CommandMenuItem</code> associated with
     * the given command, using the given accelerator key.
     *
     * @param cmd  the associated <code>Command</code>
     * @param ms   the accelerator key to use as shortcut for this command.
     **/
    public CommandMenuItem(AbstractCommand cmd, int ms) {
        super(cmd.getCommandName());
        setAccelerator(
            KeyStroke.getKeyStroke(ms, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this._cmd = cmd;
    }

    /**
     * Creates a new <code>CommandMenuItem</code> associated with
     * the given command, using the given accelerator key.
     *
     * @param cmd  the associated <code>Command</code>
     * @param ms   the accelerator key to use as shortcut for this command.
     * @param modifier the modifier that determines the modifying key(s)
     **/
    public CommandMenuItem(AbstractCommand cmd, int ms, int modifier) {
        super(cmd.getCommandName());
        setAccelerator(KeyStroke.getKeyStroke(ms, modifier));
        this._cmd = cmd;
    }

    /**
     * Gets the command of the CommandMenuItem.
     *
     * @return the command associated with the CommandMenuItem
     */
    public AbstractCommand getCommand() {
        return this._cmd;
    }

    /**
     * Sets the command for this CommandMenuItem.
     *
     * @param c the command to be associated with the CommandMenuItem
     */
    public void setCommand(AbstractCommand c) {
        this._cmd = c;
    }

    /**
     * Disposes the item, its command and uninstalls the ui.
     */
    public void dispose() {
        _cmd = null;
        this.ui.uninstallUI(this);
    }

}