package CH.ifa.draw.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * This Class contains a Map where all known plugins are stored in.
 * It's initialized with 4 base plugins and provides functionality to guess other plugins by class.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class KnownPlugins {
    private static final Map<String, String> KNOWN_PLUGINS = new HashMap<>();

    static {
        KNOWN_PLUGINS.put("de.renew.gui.CPNDrawing", "Renew Gui Plugin");
        KNOWN_PLUGINS.put("de.renew.diagram.drawing.DiagramDrawing", "Renew Diagram Plugin");
        KNOWN_PLUGINS.put("de.renew.agent.arm.diagram.ARMDrawing", "Mulan ARM Plugin");
        KNOWN_PLUGINS
            .put("de.renew.agent.modeller.diagram.view.MASDiagramDrawing", "Mulan KBE Plugin");
    }

    /**
     * Get plugin associated with a class.
     * Based on the given classname this function tries to return the equivalent plugin name.
     *
     * @param className name as String of the class, which will be looked up
     * @return name as String of the found plugin or else <code>null</code>
     */
    public static String guessPluginByClass(String className) {
        for (Entry<String, String> entry : KNOWN_PLUGINS.entrySet()) {
            if (entry.getKey().equals(className)) {
                return entry.getValue();
            }
        }
        return null;
    }
}