package CH.ifa.draw.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;


/**
 * This class is an instance of the Null Object design pattern.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class NullGraphics extends Graphics {
    private Font _font = Fontkit.getFont("Helvativa", Font.PLAIN, 12);
    private final Rectangle _clip = new Rectangle(0, 0, 0, 0);

    /**
     * Constructs a new NullGraphic object, without doing any additional setup.
     */
    public NullGraphics() {}

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        return this;
    }

    @Override
    public void dispose() {}

    @Override
    public Color getColor() {
        return Color.white;
    }

    @Override
    public void setColor(Color c) {}

    @Override
    public void setPaintMode() {}

    @Override
    public void setXORMode(Color otherColor) {}

    @Override
    public Font getFont() {
        return _font;
    }

    @Override
    public void setFont(Font font) {
        _font = font;
    }

    @Override
    public FontMetrics getFontMetrics() {
        return getFontMetrics(_font);
    }

    /**
     * It would be consequent to return another Null Object instance for the FontMetrics
     * result to avoid the deprecated method. However, the solution also requires more Null
     * Object implementations, namely of Font and its related classes GlyphVector, and
     * LineMetrics. These in turn require more Null Object implementations. So the solution
     * seems not appropriate in comparison of effort and result.
     */
    @Override
    @SuppressWarnings("deprecation")
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public java.awt.Rectangle getClipBounds() {
        return _clip;
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        setClip(x, y, w, h);
    }

    @Override
    public Shape getClip() {
        return _clip;
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {}

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(
        Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer)
    {
        return false;
    }

    @Override
    public boolean drawImage(
        Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2,
        ImageObserver observer)
    {
        return false;
    }

    @Override
    public boolean drawImage(
        Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2,
        Color bgcolor, ImageObserver observer)
    {
        return false;
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {}

    @Override
    public void fillRect(int x, int y, int w, int h) {}

    @Override
    public void clearRect(int x, int y, int w, int h) {}

    @Override
    public void drawOval(int x, int y, int w, int h) {}

    @Override
    public void fillOval(int x, int y, int w, int h) {}

    @Override
    public void drawArc(int x, int y, int w, int h, int startAngle, int arcAngle) {}

    @Override
    public void fillArc(int x, int y, int w, int h, int startAngle, int arcAngle) {}

    @Override
    public void drawRoundRect(int x, int y, int w, int h, int arcw, int arch) {}

    @Override
    public void fillRoundRect(int x, int y, int w, int h, int arcw, int arch) {}

    /**
     * Writes the path of a polygon represented by the given points.
     * But it's a no-op method so it does nothing.
     *
     * @param xPoints an array of x-coordinates of the polygon's points/vertices
     * @param yPoints an array of y-coordinates of the polygon's points/vertices
     * @param nPoints the number of points/vertices that define the polygon
     */
    public void writePolygonPath(int[] xPoints, int[] yPoints, int nPoints) {}

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {}

    @Override
    public void drawPolygon(Polygon poly) {}

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {}

    @Override
    public void fillPolygon(Polygon poly) {}

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {}

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {}

    @Override
    public void setClip(int x, int y, int w, int h) {}

    @Override
    public void setClip(Shape clip) {}

    @Override
    public void translate(int x, int y) {}

    /**
     * Scales the graphic accordingly to the parameters.
     * But it's a no-op method it does nothing
     *
     * @param xscale the scaling factor along the x-axis
     * @param yscale the scaling factor along the y-axis
     */
    public void scale(double xscale, double yscale) {}

    @Override
    public void drawString(String text, int x, int y) {}

    @Override
    public void drawBytes(byte[] data, int start, int size, int x, int y) {}

    @Override
    public void drawString(java.text.AttributedCharacterIterator iterator, int i, int j) {}
}