/*
 * @(#)StorableInOut.java 5.1
 *
 */

package CH.ifa.draw.util;

import java.net.URI;
import java.util.Vector;

import de.renew.draw.storables.ontology.Storable;


/**
 * An abstract superclass of storable input and output streams.
 * StorableInOut handles the object identity of the stored objects
 * through a map and preserves the original filename.
 * <br>
 * {@link Storable}
 * {@link StorableInput}
 * {@link StorableOutput}
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public abstract class StorableInOut {
    private final Vector<Storable> _map = new Vector<>();
    private final URI _location;

    /**
     * Constructs a StorableInOut to save storables in a Vector as well as
     * the location where the storables are saved.
     */
    protected StorableInOut() {
        this(null);
    }

    /**
     * Constructs a StorableInOut to save storables in a Vector as well as
     * the location where the storables are saved.
     *
     * @param location the URI of all storables
     */
    protected StorableInOut(URI location) {
        this._location = location;
    }

    /**
     * Getter for the URI where all storables are saved.
     *
     * @return the URI of the storable
     */
    public URI getURI() {
        return _location;
    }

    /**
     * Indicates whether the storable is saved in this class' Vector.
     *
     * @param storable the storable to check
     * @return <code>true</code>, if the storable is currently stored
     */
    protected boolean mapped(Storable storable) {
        return _map.contains(storable);
    }

    /**
     * Adds a storable to the Vector. Each storable can only be added once.
     *
     * @param storable the storable that will be added
     */
    protected void map(Storable storable) {
        if (!_map.contains(storable)) {
            _map.addElement(storable);
        }
    }

    /**
     * Gets the storable from the Vector.
     *
     * @param ref the index of the storable
     * @return the storable at the provided index
     */
    protected Storable retrieve(int ref) {
        return _map.elementAt(ref);
    }

    /**
     * Gets the index of the storable in the Vector.
     *
     * @param storable the storable the index will be looked up for
     * @return <code>index</code> of the storable if it was found<br>
     *         <code>-1</code> else
     */
    protected int getRef(Storable storable) {
        return _map.indexOf(storable);
    }
}