/*
 * @(#)FigureEnumeration.java 5.1
 *
 */

package de.renew.draw.storables.ontology;

import java.util.Enumeration;
import java.util.NoSuchElementException;

/**
 * Interface for Enumerations that access Figures.
 * It provides a method nextFigure, that hides the down casting
 * from client code.
 */
public interface FigureEnumeration extends Enumeration<Figure> {

    /**
     * Returns the next element of the enumeration. Calls to this
     * method will enumerate successive elements.
     * @exception NoSuchElementException If no more elements exist.
     * @return next element of enumeration
     */
    Figure nextFigure();
}