package de.renew.draw.storables.ontology;

import java.io.IOException;

/**
 * Interface that is used by {@link StorableInput} and {@link StorableOutput}
 * to flatten and resurrect objects. Objects that implement
 * this interface and that are resurrected by StorableInput
 * have to provide a default constructor with no arguments.
 */
public interface Storable {
    /**
     * Stores this object's data in the output.
     *
     * @param output the output channel
     */
    void write(StorableOutput output);

    /**
     * Reads the stored object's data from the Input and saves it as this object's data.
     *
     * @param input the input channel
     * @throws IOException throws IOException if an I/O error occurred
     */
    void read(StorableInput input) throws IOException;

}
