package de.renew.draw.storables.ontology.exporting;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.exporting.ExportFormatAbstract;

/**
 * Abstract implementation representing an ExportFormat for Drawings.
 */
public abstract class AbstractDrawingExportFormat extends ExportFormatAbstract<Drawing> {

    /**
     * Constructs the drawing export format with a given name and no  file filter.
     *
     * @param name the given name
     */
    public AbstractDrawingExportFormat(String name) {
        super(name);
    }

    /**
     * Constructs drawing export format with a given name and a given file filter.
     *
     * @param name the given name
     * @param fileFilter the given file filter
     */
    public AbstractDrawingExportFormat(String name, FileFilter fileFilter) {
        super(name, fileFilter);
    }

    @Override
    public boolean canExportObject(Object object) {
        if (object instanceof Drawing drawing) {
            return canExportDrawing(drawing);
        }
        return false;
    }

    /**
     * Tells whether this {@code ExportFormat} can export the given
     * {@code drawing}.
     * @param drawing  the drawing of question.
     * @return  {@code true}, if this export format can handle the
     *          given {@code drawing}.
     *          Returns {@code false}, otherwise.
     */
    public abstract boolean canExportDrawing(Drawing drawing);

}
