package de.renew.draw.ui.api;

import java.util.Vector;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.impl.services.HandleServiceImpl;
import de.renew.draw.ui.ontology.FigureHandle;

/**
 * Service class for the creation of handles for figures.
 */
public final class HandleApi {

    private static HandleServiceImpl _handleService = new HandleServiceImpl();

    /**
     * Creates a new  ElbowHandle.
     *
     * @param owner the figure to which this handle is attached
     * @param segment position within the LineConnection owner
     * @return the created ElbowHandle
     */
    public static FigureHandle createElbowHandle(Figure owner, int segment) {
        return _handleService.createElbowHandle(owner, segment);
    }

    /**
     * Creates handles for the given figure.
     * @param owner the figure to which this handle is attached
     * @return the new handles as a vector
     */
    public static Vector<FigureHandle> createBoxHandles(Figure owner) {
        return _handleService.createBoxHandles(owner);
    }

    /**
     * Creates a handle that doesn't change the owned figure. Its only purpose is
     * to show feedback that a figure is selected.
     * @param figure the figure that will receive the handle
     * @param locator Locators can be used to locate a position on a figure
     * @return the created NullHandle
     */
    public static FigureHandle createNullHandle(Figure figure, Locator locator) {
        return _handleService.createNullHandle(figure, locator);
    }

    /**
     * Creates a handle to change the font size by direct manipulation.
     * @param figure the figure that will receive the handle
     * @param locator Locators can be used to locate a position on a figure
     * @return the created FontSizeHandle
     */
    public static FigureHandle createFontSizeHandle(Figure figure, Locator locator) {
        return _handleService.createFontSizeHandle(figure, locator);
    }
}
