package de.renew.draw.ui.api;

import java.awt.Image;

import de.renew.draw.ui.api.services.ImageService;
import de.renew.draw.ui.impl.services.ImageServiceImpl;

/**
 * Service class for registering, loading and getting Images..
 */
public final class ImageApi {

    private static ImageService _imageService = new ImageServiceImpl();

    static {
        _imageService = new ImageServiceImpl();
    }

    private ImageApi() {
        // As this class only provides static functionality,
        // no instances are allowed to be created.
    }

    /**
     * Gets the image with the given name.
     * If the image can't be found it tries again after loading all the registered images.
     *
     * @param fileName the fileName, which will be used as a key to access the image
     * @return the requested Image object
     */
    public static Image getImage(String fileName) {
        return _imageService.getImage(fileName);
    }

    /**
     * Registers an image that is then loaded together with
     * the other registered images by loadRegisteredImages.
     *
     * @param fileName the name of the image file to register
     */
    public static void registerImage(String fileName) {
        _imageService.registerImage(fileName);
    }

    /**
     * Loads an image with the given name.
     *
     * @param fileName the filename where the image will be loaded from
     * @return the now loaded image
     */
    public static Image loadImage(String fileName) {
        return _imageService.loadImage(fileName);
    }

    /**
     * Registers and loads an image.
     *
     * @param fileName the filename where the image will be loaded from
     * @return the now loaded and registered image
     */
    public static Image registerAndLoadImage(String fileName) {
        return _imageService.registerAndLoadImage(fileName);
    }

    /**
     * Retrieves an Image from the editor, which can be used as the standard icon image.
     * @return the image from the editor
     */
    public static Image getIconImage() {
        return _imageService.getIconImage();
    }

}
