package de.renew.draw.ui.api.services;

import java.util.Vector;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.api.HandleApi;
import de.renew.draw.ui.ontology.FigureHandle;

/**
 * Service class that provides methods for the {@link HandleApi} to call.
 */
public interface HandleService {
    /**
     * Creates a new  ElbowHandle.
     *
     * @param owner the figure to which this handle is attached
     * @param segment position within the LineConnection owner
     * @return the created ElbowHandle
     */
    FigureHandle createElbowHandle(Figure owner, int segment);

    /**
     * Creates handles for the given figure.
     * @param owner of the new handles
     * @return the new handles as a vector
     */
    Vector<FigureHandle> createBoxHandles(Figure owner);

    /**
     * Creates a handle that doesn't change the owned figure. Its only purpose is
     * to show feedback that a figure is selected.
     * @param figure the figure that will receive the handle
     * @param locator Locators can be used to locate a position on a figure
     * @return the created NullHandle
     */
    FigureHandle createNullHandle(Figure figure, Locator locator);

    /**
     * Creates a handle to change the font size by direct manipulation.
     * @param figure the figure that will receive the handle
     * @param locator Locators can be used to locate a position on a figure
     * @return the created FontSizeHandle
     */
    FigureHandle createFontSizeHandle(Figure figure, Locator locator);
}
