package de.renew.draw.ui.impl.dialogs;

import javax.swing.JOptionPane;

import de.renew.draw.ui.ontology.dialogs.DialogMessageType;
import de.renew.draw.ui.ontology.dialogs.DialogOptionType;

/**
 * Helper class to convert Renew api types to actual implementation types.
 */
final class DialogAbstractionUtil {

    /**
     * Converts a Renew api dialog message type to a swing message type.
     * @param type the dialog message type
     * @return the swing message type as int
     */
    static int convertToSwingMessageType(DialogMessageType type) {

        return switch (type) {
            case ERROR_MESSAGE -> JOptionPane.ERROR_MESSAGE;
            case INFORMATION_MESSAGE -> JOptionPane.INFORMATION_MESSAGE;
            case WARNING_MESSAGE -> JOptionPane.WARNING_MESSAGE;
            case QUESTION_MESSAGE -> JOptionPane.QUESTION_MESSAGE;
            case PLAIN_MESSAGE -> JOptionPane.PLAIN_MESSAGE;
        };

    }

    /**
     * Converts a Renew api dialog option type to a swing option type.
     * @param type the dialog option type
     * @return the swing option type as int
     */
    static int convertToSwingOptionType(DialogOptionType type) {

        return switch (type) {
            case DEFAULT_OPTION -> JOptionPane.DEFAULT_OPTION;
            case YES_NO_OPTION -> JOptionPane.YES_NO_OPTION;
            case YES_NO_CANCEL_OPTION -> JOptionPane.YES_NO_CANCEL_OPTION;
            case OK_CANCEL_OPTION -> JOptionPane.OK_CANCEL_OPTION;
        };

    }

}
