package de.renew.draw.ui.impl.dialogs;

import de.renew.draw.ui.ontology.dialogs.InputDialogBuilder;
import de.renew.draw.ui.ontology.dialogs.MessageDialogBuilder;
import de.renew.draw.ui.ontology.dialogs.OptionDialogBuilder;

/**
 * This class provides helper methods to create new dialog builders.
 */
public class DialogCreator {

    /**
     * Creates a new builder for the message dialog.
     * @return a new {@link MessageDialogBuilder}
     */
    public static MessageDialogBuilder createMessageDialogBuilder() {
        return new MessageDialogImpl.MessageDialogBuilderImpl();
    }

    /**
     * Creates a new builder for the input dialog.
     * @return a new {@link InputDialogBuilder}
     */
    public static InputDialogBuilder createInputDialogBuilder() {
        return new InputDialogImpl.InputDialogBuilderImpl();
    }

    /**
     * Creates a new builder for the option dialog.
     * @return a new {@link OptionDialogBuilder}
     */
    public static OptionDialogBuilder createOptionDialogBuilder() {
        return new OptionDialogImpl.OptionDialogBuilderImpl();
    }

}
