package de.renew.draw.ui.impl.dialogs;

import java.awt.Component;
import javax.swing.Icon;

import de.renew.draw.ui.ontology.dialogs.Dialog;
import de.renew.draw.ui.ontology.dialogs.DialogBuilder;
import de.renew.draw.ui.ontology.dialogs.DialogMessageType;

/**
 * The DialogImpl class is the base class of all dialog implementations.
 * It provides the base fields that every dialog has.
 * @param <T> The type of the dialog builder that was used to create this dialog
 */
sealed abstract class DialogImpl<T extends DialogBuilder<?>> implements Dialog<T>
    permits InputDialogImpl, MessageDialogImpl, OptionDialogImpl
{

    protected final Component _parentComponent;
    protected final String _title;
    protected final DialogMessageType _messageType;
    protected final Icon _icon;
    protected final Object _message;

    /**
     * Creates a new instance of a DialogImpl
     * @param parentComponent the parent component used for the dialog
     * @param title the title of the dialog
     * @param messageType the dialog message type
     * @param icon the icon of the dialog
     * @param message the message to display
     */
    protected DialogImpl(
        Component parentComponent, String title, DialogMessageType messageType, Icon icon,
        Object message)
    {
        _parentComponent = parentComponent;
        _title = title;
        _messageType = messageType;
        _icon = icon;
        _message = message;
    }

}
