package de.renew.draw.ui.impl.dialogs;

import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import de.renew.draw.ui.ontology.dialogs.DialogMessageType;
import de.renew.draw.ui.ontology.dialogs.InputDialog;
import de.renew.draw.ui.ontology.dialogs.InputDialogBuilder;

/**
 * This is the implementation of the input dialog.
 */
final class InputDialogImpl extends DialogImpl<InputDialogBuilder> implements InputDialog {

    private final Object[] _selectionValues;
    private final Object _initialSelectionValue;

    private InputDialogImpl(
        Component parentComponent, String title, DialogMessageType messageType, Icon icon,
        Object message, Object[] selectionValues, Object initialSelectionValue)
    {
        super(parentComponent, title, messageType, icon, message);
        this._selectionValues = selectionValues;
        this._initialSelectionValue = initialSelectionValue;
    }

    @Override
    public Object show() {
        return JOptionPane.showInputDialog(
            this._parentComponent, this._message, this._title,
            DialogAbstractionUtil.convertToSwingMessageType(this._messageType), this._icon,
            this._selectionValues, this._initialSelectionValue);
    }

    @Override
    public void showAsync(Consumer<Object> onInput) {

        SwingUtilities.invokeLater(() -> onInput.accept(show()));

    }

    @Override
    public InputDialogBuilder toNewBuilder() {
        return new InputDialogBuilderImpl().setParentComponent(this._parentComponent)
            .setTitle(this._title).setMessageType(this._messageType).setIcon(this._icon)
            .setMessage(this._message).setSelectionValues(this._selectionValues)
            .setInitialSelectionValue(this._initialSelectionValue);
    }

    /**
     * The builder of the input dialog.
     */
    static final class InputDialogBuilderImpl extends DialogBuilderImpl<InputDialogBuilder>
        implements InputDialogBuilder
    {

        private Object[] _selectionValues = null;
        private Object _initialSelectionValue = null;

        /**
         * Creates a new instance of the InputDialogBuilder, used to create {@link InputDialog}s.
         */
        InputDialogBuilderImpl() {}

        @Override
        public InputDialogBuilderImpl setSelectionValues(Object[] selectionValues) {
            this._selectionValues = selectionValues;
            return this;
        }

        @Override
        public InputDialogBuilderImpl setInitialSelectionValue(Object initialSelectionValue) {
            this._initialSelectionValue = initialSelectionValue;
            return this;
        }

        @Override
        protected InputDialogBuilderImpl self() {
            return this;
        }

        @Override
        public InputDialogImpl build() {
            return new InputDialogImpl(
                this._parentComponent, this._title, this._messageType, this._icon, this._message,
                this._selectionValues, this._initialSelectionValue);
        }

    }

}
