package de.renew.draw.ui.impl.services;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.standard.StandardDrawingView;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingListener;
import de.renew.draw.ui.api.services.EditorService;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;

/**
 * Contains the editor functionalities for the editor service.
 * It acts as a facade by not providing the functionality itself but redirecting its calls to the {@link DrawPlugin}.
 */
public class EditorServiceImpl implements EditorService {

    @Override
    public void loadAndOpenDrawings(URL url) {
        IOHelper.getInstance().loadAndOpenDrawings(url);
    }

    @Override
    public void loadAndOpenDrawings(InputStream stream, String fileName) throws IOException {
        IOHelper.getInstance().loadAndOpenDrawings(stream, fileName);
    }

    @Override
    public void openOrLoadDrawing(File file) {
        DrawPlugin.getGui().openOrLoadDrawing(file);
    }

    @Override
    public void checkDamage() {
        DrawPlugin.getGui().view().checkDamage();
    }

    @Override
    public void repairDamage() {
        DrawPlugin.getGui().view().repairDamage();
    }

    @Override
    public void toolDone() {
        DrawPlugin.getGui().toolDone();
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        ((StandardDrawingView) DrawPlugin.getGui().view()).addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        ((StandardDrawingView) DrawPlugin.getGui().view()).removeMouseListener(mouseListener);
    }

    @Override
    public DrawingEditor getCurrentEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin == null) {
            return NullDrawingEditor.INSTANCE;
        }
        return drawPlugin.getDrawingEditor();
    }

    @Override
    public DrawingEditor getNullDrawingEditor() {
        return NullDrawingEditor.INSTANCE;
    }

    @Override
    public DrawingView getNullDrawingView() {
        return NullDrawingView.INSTANCE;
    }

    @Override
    public Drawing getCurrentDrawing() {
        return DrawPlugin.getGui().drawing();
    }

    @Override
    public Enumeration<Drawing> getCurrentDrawings() {
        return DrawPlugin.getGui().drawings();
    }

    @Override
    public Drawing openDrawing(Drawing drawing) {
        return DrawPlugin.getGui().openDrawing(drawing);
    }

    @Override
    public void openDrawing(Drawing drawing, Point point, Dimension dimension) {
        DrawPlugin.getGui().openDrawing(new PositionedDrawing(point, dimension, drawing));
    }

    @Override
    public void closeDrawing(Drawing drawing) {
        DrawPlugin.getGui().closeDrawing(drawing);
    }

    @Override
    public void addDrawingListener(DrawingListener listener) {
        DrawPlugin.getGui().addDrawingListener(listener);
    }

    @Override
    public void removeDrawingListener(DrawingListener listener) {
        DrawPlugin.getGui().removeDrawingListener(listener);
    }
}
