package de.renew.draw.ui.impl.services;

import java.util.Vector;

import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.standard.NullHandle;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.api.services.HandleService;
import de.renew.draw.ui.ontology.FigureHandle;

/**
 * Contains the functionalities for the HandleService.
 * It acts as a facade by not providing the functionality itself but redirecting its calls to
 * {@link ElbowHandle}, {@link BoxHandleKit},{@link NullHandle} and {@link FontSizeHandle}.
 */
public class HandleServiceImpl implements HandleService {
    @Override
    public FigureHandle createElbowHandle(Figure owner, int segment) {
        if (!(owner instanceof LineConnection)) {
            throw new IllegalArgumentException("Parameter Figure must be a LineConnection");
        }
        return new ElbowHandle((LineConnection) owner, segment);
    }

    @Override
    public Vector<FigureHandle> createBoxHandles(Figure owner) {
        Vector<FigureHandle> handleVector = new Vector<>();
        return BoxHandleKit.addHandles(owner, handleVector);
    }

    @Override
    public FigureHandle createNullHandle(Figure figure, Locator locator) {
        return new NullHandle(figure, locator);
    }

    @Override
    public FigureHandle createFontSizeHandle(Figure figure, Locator locator) {
        return new FontSizeHandle(figure, locator);
    }
}
