package de.renew.draw.ui.ontology;

import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;

/**
 * Commands encapsulate an action to be executed. Commands have
 * a name and can be used in conjunction with <i>Command enabled</i>
 * ui components.
 * AbstractCommand is the base class of every command created. It includes simple name and execute functionality.
 *
 * <hr>
 * {@link CommandMenu}
 * {@link CommandMenuItem}
 */
public abstract class AbstractCommand {

    /**
     * The name of the command.
     */
    private String _commandName;

    /**
     * The state if the command is executable.
     */
    private boolean _isExecutable = true;

    /**
     * Constructs a command with the given name.
     * @param name the name of the command.
     */
    public AbstractCommand(String name) {
        _commandName = name;
    }

    /**
     * Executes the command.
     */
    public abstract void execute();

    /**
     * Tests if the command can be executed.
     * @return the state if the command is executable.
     */
    public boolean isExecutable() {
        return _isExecutable;
    }

    /**
     * Set if the command can be executed.
     * @param executable set the command executable to true/false.
     */
    public void setIsExecutable(boolean executable) {
        _isExecutable = executable;
    }

    /**
     * Gets the command name.
     * @return the name of the command.
     */
    public final String getCommandName() {
        return _commandName;
    }

    /**
     * Sets the name of the command.
     * @param name new name of command
     */
    public final void setCommandName(String name) {
        _commandName = name;
    }

    /**
     * Gets possible arguments for this command.
     * <br>
     * {@link de.renew.plugin.command.CLCommand#getArguments()}
     * @return null.
     */
    public String getArguments() {
        return null;
    }

}
