/*
 * @(#)Painter.java 5.1
 *
 */

package de.renew.draw.ui.ontology;

import java.awt.Graphics;
import java.io.Serializable;

/**
 * Painter defines the interface for drawing a layer
 * into a DrawingView.
 * <hr>
 * <b>Design Patterns</b><P>
 * <img src="images/red-ball-small.gif" width=6 height=6 alt=" o ">
 * <b><a href=../pattlets/sld034.htm>Strategy</a></b><br>
 * Painter encapsulates an algorithm to render something in
 * the DrawingView. The DrawingView plays the role of the StrategyContext.
 * <hr>
 * @see DrawingView
 */
@FunctionalInterface
public interface Painter extends Serializable {

    /**
     * Draws into the given DrawingView.
     * @param g graphic to be drawn into
     * @param view instance of DrawingView
     */
    void draw(Graphics g, DrawingView view);
}