package de.renew.draw.ui.ontology;

/** Enum specifiying operation modes for a spread command. */
public enum SpreadMode {
    /** Equalize distance between left sides */
    LEFTS,

    /** Equalize distance between centers (horizontally) */
    CENTERS,

    /** Equalize distance between right sides */
    RIGHTS,

    /** Equalize distance between tops */
    TOPS,

    /** Equalize distance between middles (vertically) */
    MIDDLES,

    /** Equalize distance between bottoms */
    BOTTOMS,

    /** Equalize space between bounding rectangles (horizontally) **/
    HORIZONTAL_DISTANCE,

    /** Equalize space between bounding rectangles (vertically) **/
    VERTICAL_DISTANCE,

    /**
     * Operation mode: line up all figures along a straight line,
     * the line may be of any gradient. The center of each figure
     * is relevant.
     **/
    DIAGONAL_CENTERS
}
