package de.renew.draw.ui.ontology.dialogs;

/**
 * Base Dialog used for all types of ui dialogs used in Renew.
 * The type defines the {@link DialogBuilder} of the dialog used.<br>
 * {@link InputDialog} {@link MessageDialog} {@link OptionDialog}
 */
public interface Dialog<T extends DialogBuilder<?>> {

    /**
     * Creates and returns a new builder instance for constructing a dialog.
     *
     * @return A new instance of a builder that can be used to create a new dialog based upon this instance.
     */
    T toNewBuilder();

}
