package de.renew.draw.ui.ontology.dialogs;

import java.util.function.Consumer;

/**
 * The InputDialog represents a dialog that requests a user input.
 */
public interface InputDialog extends Dialog<InputDialogBuilder> {

    /**
     * Open and show the dialog.
     * This is a blocking call, opening the dialog window.
     * @return The user input
     */
    Object show();

    /**
     * Open and show the dialog asynchronously.
     * This is not a blocking call.
     * @param onInput The callback to be called when an input is given.
     */
    void showAsync(Consumer<Object> onInput);

}
