package de.renew.draw.ui.ontology.dialogs;

/**
 * Dialog builder for the {@link InputDialog}.
 */
public interface InputDialogBuilder extends DialogBuilder<InputDialogBuilder> {

    /**
     * Sets the available options for the input.
     * @param selectionValues Options to be listed within the dialog
     * @return The builder instance
     */
    InputDialogBuilder setSelectionValues(Object[] selectionValues);

    /**
     * Sets the initial selection value.
     * @param initialSelectionValue The initial value to be set
     * @return The builder instance
     */
    InputDialogBuilder setInitialSelectionValue(Object initialSelectionValue);

    /**
     * Builds the dialog based on the builder.
     * @return The created dialog.
     */
    InputDialog build();

}
