package de.renew.draw.ui.ontology.dialogs;

import java.util.function.Consumer;

/**
 * The OptionDialog represents a dialog with a set range of options available to choose from.
 */
public interface OptionDialog extends Dialog<OptionDialogBuilder> {

    /**
     * Open and show the dialog.
     * This is a blocking call, opening the dialog window.
     * @return The id of the selected option
     */
    int show();

    /**
     * Open and show the dialog asynchronously.
     * This is not a blocking call.
     * @param onOptionSelected The callback to be called when an option is selected.
     */
    void showAsync(Consumer<Integer> onOptionSelected);

}
