package de.renew.draw.ui.ontology.undoredo;

/**
 * Keeps a history of snapshots of a drawing.
 * Provides methods to take a new snapshot and to
 * restore the latest snapshot.
 *
 * @author Clara von Bargen
 *
 * @deprecated This interface is not to be used externally. Please use the {@link de.renew.draw.ui.api.UndoRedoApi} instead.
 */
@Deprecated(since = "5.0", forRemoval = true)
public interface SnapshotHistory {

    /**
     * Takes a snapshot of all figures which are currently part
     * of the drawing and appends it to the history.
     * If the history limit is exceeded, the oldest snapshot will
     * be removed from the history.
     */
    void takeSnapshot();

    /**
     * Prepares a snapshot for commitSnapshot().
     * Any previously prepared snapshot will be forgotten.
     */
    void prepareSnapshot();

    /**
     * Takes the last prepared snapshot of all figures which are
     * currently part of the drawing and appends it to the history.
     * If the history limit is exceeded, the oldest snapshot will
     * be removed from the history.
     */
    void commitSnapshot();

    /**
     * Restores the latest snapshot of the drawing.
     * Replaces all figures currently contained in the drawing
     * by the figures in the snapshot.
     * <p>
     * If the history is empty, nothing will happen.
     */
    void restoreSnapshot();

    /**
     * Removes all snapshots from the history.
     */
    void clear();

    /**
     * Checks whether the history is empty.
     * @return boolean, {@code true} if empty
     */
    boolean isEmpty();
}
