package de.renew.io.api.services;

import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileType;

/**
 * Contains the file functionalities for the file api to call.
 *
 * @author Clara von Bargen
 */
public interface FileService {

    /**
     * Constructs a new ExtensionFileFilter with the given extension and description.
     * @param extension the file extension
     * @param description description of file type
     * @return the created ExtensionFileFilter
     */
    ExtensionFileFilter createExtensionFileFilter(String extension, String description);

    /**
     * Constructs a new ExtensionFileFilter with the given extension and description.
     * @param fileType the file type
     * @return the created ExtensionFileFilter
     */
    ExtensionFileFilter createExtensionFileFilter(FileType fileType);
}
