package de.renew.ioontology;


/**
 * Enum containing known file types, that are each characterized by an extension and a description.
 */
public enum FileType {

    /** The draw file type (simple drawings).*/
    DRAW("draw", "Simple Drawing (*.draw)"),

    /** The eps file type (Encapsulated PostScript).*/
    EPS("eps", "Encapsulated Post Script File"),
    /** The pdf file type (Portable Document Format).*/
    PDF("pdf", "Portable Document Format"),
    /** The svg file type (Scalable Vector Graphics).*/
    SVG("svg", "Scalable Vector Graphic"),

    /** The gif file type (Graphics Interchange Format).*/
    GIF("gif", "Graphics Interchange Format File"),
    /** The jpg file type (Joint Photographic Experts Group).*/
    JPG("jpg", " Joint Photographic Experts Group File"),
    /** The jpeg file type (Joint Photographic Experts Group).*/
    JPEG("jpeg", " Joint Photographic Experts Group File"),
    /** The png file type (Portable Network Graphics).*/
    PNG("png", "Portable Network Graphics File");


    private final String _extension;
    private final String _description;

    FileType(String extension, String description) {
        _extension = extension;
        _description = description;
    }

    /**
     * Gets the description of the file type.
     * @return the description of the file type
     */
    public String getDescription() {
        return _description;
    }

    /**
     * Gets the extension of the file type.
     * @return the extension of the file type
     */
    public String getExtension() {
        return _extension;
    }
}
