package de.renew.ioontology;

import java.util.Collection;
import java.util.Set;

/**
 * The file filter describing a combination of multiple accepted extensions.
 * One file filter is given as the preferred filter.
 */
public interface MultiExtensionFileFilter extends FileFilter {
    /**
     * Adds the given {@link ExtensionFileFilter} to this multi extension file filter.
     *
     * @param ff the given filter
     * @return {@code true} if the filter was added successfully, {@code false} otherwise
     */
    boolean add(ExtensionFileFilter ff);

    /**
     * Adds the given {@link ExtensionFileFilter}s to this multi extension file filter.
     *
     * @param filters the given filters
     * @return {@code true} if the filter was added successfully, {@code false} otherwise
     */
    boolean addAll(Collection<? extends ExtensionFileFilter> filters);

    /**
     * Removes the given {@link ExtensionFileFilter} from this multi extension file filter.
     *
     * @param ff the given filter
     */
    void remove(ExtensionFileFilter ff);

    /**
     * Gets the set of {@link ExtensionFileFilter}s contained in this multi extension file filter.
     *
     * @return the set of {@link ExtensionFileFilter}s contained in this multi extension file filter
     */
    Set<ExtensionFileFilter> getFileFilters();

    /**
     * Gets the preferred {@link ExtensionFileFilter}.
     *
     * @return the preferred {@link ExtensionFileFilter}
     */
    ExtensionFileFilter getPreferredFileFilter();

    /**
     * Sets the preferred {@link ExtensionFileFilter} to the given filter.
     *
     * @param filter the given filter
     */
    void setPreferredFileFilter(ExtensionFileFilter filter);
}
