package de.renew.ioontology.exporting;

import java.util.List;

/**
 * Container for ExportFormats. Is an ExportFormat itself.
 * Can be used to arrange ExportFormats in groups.
 * @param <T> the type of the Object that is exported
 */
public interface ExportFormatMulti<T> extends ExportFormat<T> {

    /**
     * Adds a format to the MultiFormat.
     * @param format The format to be added to MultiFormat
     */
    void addExportFormat(ExportFormat<T> format);

    /**
     * Remove a format from the MultiFormat.
     * @param format the format to be removed
     */
    void removeExportFormat(ExportFormat<T> format);

    /**
     * Returns all formats in the MultiFormat.
     * @return All formats of MultiFormat
     */
    List<ExportFormat<T>> getExportFormats();
}