package de.renew.ioontology.importing;

import java.net.URI;
import java.net.URL;
import java.util.List;

import de.renew.ioontology.FileFilter;

/**
 * This interface must be implemented to define new ImportFormats.
 *
 * @param <T> The type of the object that is the result of the import.
 */
public interface ImportFormat<T> {

    /**
     * Converts an array of files into a list of objects.
     * @throws Exception is caught by the import format holder
     * @param paths array of paths to the files to be imported
     * @return list of objects
     */
    List<T> importFiles(URL[] paths) throws Exception;

    /**
     * Returns the FileFilter for the ImportFormat.
     * @return FileFilter the FileFilter for the ImportFormat
     */
    FileFilter fileFilter();

    /**
     * Returns a name for the ImportFormat e.g. PNML.
     * @return the name of the ImportFormat
     */
    String formatName();

    /**
     * Checks if the file can be imported.
     * @param path path to the file to be checked
     * @return {@code true} if the import is possible; {@code false} if the import is NOT possible
     */
    boolean canImport(URL path);

    /**
     * Checks if the file can be imported.
     * @param path URI to be checked
     * @return {@code true} if the import is possible; {@code false} if the import is NOT possible
     */
    boolean canImport(URI path);
}