package de.renew.ioontology.importing;

import java.util.List;

/**
 * Interface representing a type holding import formats.
 * @param <T> the type for which the import format is applied
 */
public interface ImportFormatHolder<T> {

    /**
     * Adds an ImportFormat to Renew.
     * @param importFormat The ImportFormat which is added to Renew
     */
    void addImportFormat(ImportFormat<T> importFormat);

    /**
     * Adds the given listener to react to changes in the known import formats.
     *
     * @param listener the listener which is to be added
     */
    void addImportFormatListener(ImportFormatListener<T> listener);


    /**
     * Removes an ImportFormat from Renew.
     * @param format The importFormat to be removed
     */
    void removeImportFormat(ImportFormat<T> format);

    /**
     * Removes the given import format listener.
     *
     * @param listener the listener which is to be removed
     */
    void removeImportFormatListener(ImportFormatListener<T> listener);

    /**
     * Returns a list that contains all ImportFormats added to Renew.
     * @return list containing all ImportFormats added to Renew
     */
    List<ImportFormat<T>> getImportFormats();
}