package de.renew.ioontology.importing;


import java.util.EventListener;

/**
 * Type that allows to react to changes in the known import formats.
 * @param <T> the type of objects the import formats are related to
 */
public interface ImportFormatListener<T> extends EventListener {

    /**
     * Reaction for the addition of the given import format.
     * @param addedFormat the import format that is added
     */
    void importFormatAdded(ImportFormat<T> addedFormat);

    /**
     * Reaction for the removal of the given import format.
     * @param removedFormat the import format that is added
     */
    void importFormatRemoved(ImportFormat<T> removedFormat);
}
