package CH.ifa.draw.figures;

import java.awt.Point;
import java.util.Enumeration;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class SmoothPolyLineFigureTest {
    private static SmoothPolyLineFigure _testee;

    @BeforeEach
    public void setUp() {
        _testee = new SmoothPolyLineFigure(0.2);
    }

    /**
     * Test initialization to create a new SmoothPolyLineFigure instance
     */
    @Test
    public void testConstructorWithGivenPoint() {
        //given
        int x = 100;
        int y = 200;
        //when
        SmoothPolyLineFigure figureWithPoint = new SmoothPolyLineFigure(x, y, 0.2);
        Enumeration<Point> pointEnumeration = figureWithPoint.points();
        //then
        assertEquals(new Point(x, y), pointEnumeration.nextElement());
    }

    /**
     * Test adding a single point to the figure
     */
    @Test
    public void testAddSinglePoint() {
        //given
        Point examplePoint = new Point(100, 200);
        //when
        _testee.addPoint(examplePoint.x, examplePoint.y);
        //then
        assertEquals(examplePoint, _testee.points().nextElement());
    }

    /**
     * Test adding a multiple points to the figure
     */
    @Test
    public void testAddMultiplePoints() {
        //given
        Point examplePoint1 = new Point(100, 200);
        Point examplePoint2 = new Point(200, 240);
        Point examplePoint3 = new Point(300, 260);
        //when
        _testee.addPoint(examplePoint1.x, examplePoint1.y);
        _testee.addPoint(examplePoint1.x, examplePoint2.y);
        _testee.addPoint(examplePoint1.x, examplePoint3.y);
        //then
        assertTrue(_testee.pointCount() >= 2);
    }

    /**
     * Test adding a multiple points on the same line
     * When the points are on the same line, the SmoothPolyLineFigureTest should simplify the points and remove redundant points and only keep the first and last point.
     */
    @Test
    public void testAddPointsOnSameLine() {
        //given
        Point examplePoint1 = new Point(100, 200);
        Point examplePoint2 = new Point(200, 200);
        Point examplePoint3 = new Point(300, 200);
        //when
        _testee.addPoint(examplePoint1.x, examplePoint1.y);
        _testee.addPoint(examplePoint1.x, examplePoint2.y);
        _testee.addPoint(examplePoint1.x, examplePoint3.y);
        //then
        assertEquals(2, _testee.pointCount());
    }

}
