package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

class IFAFileFilterTest {
    private IFAFileFilter _filter;

    @BeforeEach
    public void setUp() {
        _filter = new IFAFileFilter();
    }

    /**
     * This test verifies the functionality of the .accept() method and checks if a file with the .draw extension gets accepted, as it should.
     */
    @Test
    public void testAcceptIFA() {
        //given
        File file = new File("drawing.draw");
        //when/then
        assertThat(_filter.accept(file)).isTrue();
    }

    /**
     * This test checks if a non-IFA-File is rejected correctly.
     */
    @Test
    public void testAcceptNotIFA() {
        //given
        File file = new File("picture.png");
        //when/then
        assertThat(_filter.accept(file)).isFalse();
    }

    /**
     * This test checks if the description of a newly created painting filter matches the expected description.
     */
    @Test
    public void testGetDescription() {
        //when/then
        assertThat(_filter.getDescription()).isEqualTo("Simple Drawing (*.draw)");
    }
}
