package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class ImageFileFilterTest {

    private final ImageFileFilter _filter = new ImageFileFilter();

    @Test
    void testDescription() {
        assertEquals(
            "Image File (png, jpg, gif)", _filter.getDescription(),
            "The description of the image file must match");
    }

    @Test
    void testAcceptsPng() {
        assertTrue(_filter.accept(new File("image.png")), ".png should be accepted");
    }

    @Test
    void testAcceptsJpgAndJpeg() {
        assertTrue(_filter.accept(new File("image.jpg")), ".jpg should be accepted");
        assertTrue(_filter.accept(new File("image.jpeg")), ".jpeg should be accepted");
    }

    @Test
    void testAcceptsGif() {
        assertTrue(_filter.accept(new File("animation.gif")), ".gif should be accepted");
    }

    @Test
    void testRejectsOtherExtensions() {
        assertFalse(_filter.accept(new File("document.txt")), ".txt should be rejected");
        assertFalse(_filter.accept(new File("archive.zip")), ".zip should be rejected");
    }
}