package CH.ifa.draw.standard;

import java.util.Optional;

import org.junit.jupiter.api.Test;

import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.TextFigure;

import static org.assertj.core.api.Assertions.assertThat;

class FigureExceptionTest {

    @Test
    void testGetErroneousFigureNoFigureGiven() {
        //given
        FigureException figureException =
            new FigureException("Dummy-Message", 1, 2, null, null, null);

        //when
        Optional<TextFigure> erroneousFigure = figureException.getErroneousFigure(TextFigure.class);

        // then
        assertThat(erroneousFigure).isEmpty();
    }

    @Test
    void testGetErroneousFigureWrongFigureGiven() {
        //given
        FigureException figureException =
            new FigureException("Dummy-Message", 1, 2, null, new EllipseFigure(), null);

        //when
        Optional<TextFigure> erroneousFigure = figureException.getErroneousFigure(TextFigure.class);

        // then
        assertThat(erroneousFigure).isEmpty();
    }

    @Test
    void testGetErroneousFigureRightFigureGiven() {
        //given
        EllipseFigure expectedFigure = new EllipseFigure();
        FigureException figureException =
            new FigureException("Dummy-Message", 1, 2, null, expectedFigure, null);

        //when
        Optional<EllipseFigure> erroneousFigure =
            figureException.getErroneousFigure(EllipseFigure.class);

        // then
        assertThat(erroneousFigure).isNotEmpty().get().isInstanceOf(EllipseFigure.class)
            .isEqualTo(expectedFigure);
    }
}