package CH.ifa.draw.standard;

import java.awt.event.MouseEvent;
import java.util.Vector;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

public class SelectionToolTest {
    private SelectionTool _selectionTool;
    private StandardDrawingView _view;
    private Figure _figure;

    @BeforeEach
    public void setup() {
        DrawingEditor editor = mock(DrawingEditor.class);
        Drawing drawing = mock(Drawing.class);
        _view = mock(StandardDrawingView.class);
        _figure = mock(Figure.class);
        _selectionTool = new SelectionTool(editor);
        when(editor.view()).thenReturn(_view);
        when(editor.drawing()).thenReturn(drawing);
        when(drawing.findFigure(10, 10)).thenReturn(_figure);
        when(_view.selection()).thenReturn(new Vector<>());
    }

    @Test
    public void testSimpleLeftClick() {
        MouseEvent event = mock(MouseEvent.class);
        when(event.getModifiersEx()).thenReturn(MouseEvent.BUTTON1_DOWN_MASK);

        _selectionTool.mouseDown(event, 10, 10);

        verify(_view).addToSelection(_figure);
    }

    @Test
    public void testSimpleRightClick() {
        MouseEvent event = mock(MouseEvent.class);
        when(event.getModifiersEx()).thenReturn(MouseEvent.BUTTON2_DOWN_MASK);

        _selectionTool.mouseDown(event, 10, 10);

        verify(_figure).inspect(any(), eq(true));
    }

    @Test
    public void testSimpleMiddleClick() {
        MouseEvent event = mock(MouseEvent.class);
        when(event.getModifiersEx()).thenReturn(MouseEvent.BUTTON3_DOWN_MASK);

        _selectionTool.mouseDown(event, 10, 10);

        verify(_figure).inspect(any(), eq(true));
    }
}
