package de.renew.draw.ui.api;

import java.lang.reflect.Field;
import java.util.Vector;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import CH.ifa.draw.figures.ElbowHandle;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.impl.services.HandleServiceImpl;
import de.renew.draw.ui.ontology.FigureHandle;

import static org.assertj.core.api.AssertionsForInterfaceTypes.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

class HandleApiTest {

    private HandleServiceImpl _handleService;

    @BeforeEach
    void setUp() throws IllegalAccessException, NoSuchFieldException {
        _handleService = mock(HandleServiceImpl.class);
        Field serviceField = HandleApi.class.getDeclaredField("_handleService");
        serviceField.setAccessible(true);
        serviceField.set(null, _handleService);
    }

    @AfterEach
    void tearDown() {
        _handleService = null;
    }

    @ParameterizedTest
    @ValueSource(ints = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 })
    void testCreateElbowHandle(int segment) {
        //given
        Figure figure = mock(Figure.class);
        FigureHandle controlHandle = mock(ElbowHandle.class);
        when(_handleService.createElbowHandle(figure, segment)).thenReturn(controlHandle);
        //when
        FigureHandle returnedHandle = HandleApi.createElbowHandle(figure, segment);
        //then
        verify(_handleService).createElbowHandle(figure, segment);
        assertThat(returnedHandle).isEqualTo(controlHandle);
    }

    @Test
    void testCreateBoxHandles() {
        //given
        Figure figure = mock(Figure.class);
        Vector<FigureHandle> controlVector = new Vector<>();
        when(_handleService.createBoxHandles(figure)).thenReturn(controlVector);
        //when
        Vector<FigureHandle> returnedVector = HandleApi.createBoxHandles(figure);
        //then
        verify(_handleService).createBoxHandles(figure);
        assertThat(returnedVector).isEqualTo(controlVector);
    }

    @Test
    void testCreateNullHandle() {
        //given
        Figure figure = mock(Figure.class);
        Locator locator = mock(Locator.class);
        FigureHandle controlHandle = mock(FigureHandle.class);
        when(_handleService.createNullHandle(figure, locator)).thenReturn(controlHandle);
        //when
        FigureHandle returnedHandle = HandleApi.createNullHandle(figure, locator);
        //then
        verify(_handleService).createNullHandle(figure, locator);
        assertThat(controlHandle).isEqualTo(returnedHandle);
    }

    @Test
    void testCreateFontSizeHandle() {
        //given
        Figure figure = mock(Figure.class);
        Locator locator = mock(Locator.class);
        FigureHandle controlHandle = mock(FigureHandle.class);
        when(_handleService.createFontSizeHandle(figure, locator)).thenReturn(controlHandle);
        //when
        FigureHandle returnedHandle = HandleApi.createFontSizeHandle(figure, locator);
        //then
        verify(_handleService).createFontSizeHandle(figure, locator);
        assertThat(controlHandle).isEqualTo(returnedHandle);
    }
}