package de.renew.draw.ui.api;

import java.lang.reflect.Field;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.impl.services.UndoRedoServiceImpl;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

class UndoRedoApiTest {

    private static final Drawing DUMMY_DRAWING = mock(Drawing.class);

    private UndoRedoServiceImpl _mockedService;

    @BeforeEach
    void setUp() throws NoSuchFieldException, IllegalAccessException {
        _mockedService = mock(UndoRedoServiceImpl.class);
        Field serviceField = UndoRedoApi.class.getDeclaredField("_service");
        serviceField.setAccessible(true);
        serviceField.set(null, _mockedService);
    }

    @AfterEach
    void tearDown() {
        _mockedService = null;
    }

    @Test
    void testPrepareUndoSnapshot() {
        //when
        UndoRedoApi.prepareUndoSnapshot();

        // then
        verify(_mockedService).prepareUndoSnapshot();
    }

    @Test
    void testPrepareUndoSnapshotWithDrawing() {
        //when
        UndoRedoApi.prepareUndoSnapshot(DUMMY_DRAWING);

        // then
        verify(_mockedService).prepareUndoSnapshot(DUMMY_DRAWING);
    }

    @Test
    void testCommitUndoSnapshot() {
        //when
        UndoRedoApi.commitUndoSnapshot();

        // then
        verify(_mockedService).commitUndoSnapshot();
    }

    @Test
    void testCommitUndoSnapshotWithDrawing() {
        //when
        UndoRedoApi.commitUndoSnapshot(DUMMY_DRAWING);

        // then
        verify(_mockedService).commitUndoSnapshot(DUMMY_DRAWING);
    }

    @Test
    void testClearUndoRedoHistory() {
        //when
        UndoRedoApi.clearUndoRedoHistory();

        // then
        verify(_mockedService).clearUndoRedoHistory();
    }

    @Test
    void testClearUndoRedoHistoryWithDrawing() {
        //when
        UndoRedoApi.clearUndoRedoHistory(DUMMY_DRAWING);

        // then
        verify(_mockedService).clearUndoRedoHistory(DUMMY_DRAWING);
    }

    @Test
    void testRestoreUndoSnapshot() {
        //when
        UndoRedoApi.restoreUndoSnapshot();

        // then
        verify(_mockedService).restoreUndoSnapshot();
    }

    @Test
    void testRestoreUndoSnapshotWithDrawing() {
        //when
        UndoRedoApi.restoreUndoSnapshot(DUMMY_DRAWING);

        // then
        verify(_mockedService).restoreUndoSnapshot(DUMMY_DRAWING);
    }
}