package de.renew.draw.ui.impl.services;

import java.awt.Image;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.mockStatic;
import static org.mockito.Mockito.when;

class ImageServiceImplTest {
    ImageServiceImpl _imageService;

    @BeforeEach
    void setUp() {
        this._imageService = new ImageServiceImpl();
    }

    @AfterEach
    void tearDown() {
        this._imageService = null;
    }

    @Test
    void getImage() {
        //given
        String fileName = "tools/images/1.gif";
        //when
        _imageService.registerImage(fileName);
        Image retrievedImage = _imageService.getImage(fileName);
        //then
        assertThat(retrievedImage).isNotNull();
    }

    @Test
    void registerImage() {
        //given
        String path = "tools/images/1.gif";
        //when
        _imageService.registerImage(path);
        Image retrievedImage = _imageService.getImage(path);
        //then
        assertThat(retrievedImage).isNotNull();
    }

    @Test
    void loadImage() {
        //given
        String path = "tools/images/1.gif";
        //when
        Image loadedImage = _imageService.loadImage(path);
        Image retrievedImage = _imageService.getImage(path);
        // then
        assertThat(retrievedImage).isNotNull();
        assertThat(retrievedImage).isEqualTo(loadedImage);
    }

    @Test
    void registerAndLoadImage() {
        //given
        String path = "tools/images/1.gif";
        //when
        Image registeredImage = _imageService.registerAndLoadImage(path);
        Image retrievedImage = _imageService.getImage(path);
        //then
        assertThat(retrievedImage).isNotNull();
        assertThat(retrievedImage).isEqualTo(registeredImage);
    }

    @Test
    void testGetIconImage() {
        //given
        Image image = mock(Image.class);
        DrawApplication drawApplication = mock(DrawApplication.class);
        try (MockedStatic<DrawPlugin> mocked = mockStatic(DrawPlugin.class)) {
            mocked.when(DrawPlugin::getGui).thenReturn(drawApplication);
            when(drawApplication.getIconImage()).thenReturn(image);
            //when/then
            assertThat(_imageService.getIconImage()).isEqualTo(image);
        }
    }
}