package de.renew.console;

import de.renew.plugin.IPlugin;
import de.renew.plugin.SoftDependencyListener;

/**
 * This class implements the SoftDependencyListener interface
 * and manages the availability of a CH plugin by storing a reference to it
 * when available and clearing it when removed.
 * It provides a static method getChPlugin() to access the currently
 * available plugin instance.
 */

public class CHDependencyListener implements SoftDependencyListener {
    private static IPlugin _chPlugin = null;

    /**
     * Creates a new instance of {@code CHDependencyListener}.
     * This default constructor performs no special initialization.
     */
    public CHDependencyListener() {}

    @Override
    public void serviceAvailable(IPlugin plugin) {
        CHDependencyListener._chPlugin = plugin;
    }

    @Override
    public void serviceRemoved(IPlugin plugin) {
        CHDependencyListener._chPlugin = null;
    }

    /**
     * Retrieves the current `chPlugin` instance.
     *
     * @return the {@link IPlugin} instance representing the current plugin.
     */
    public static IPlugin getChPlugin() {
        return _chPlugin;
    }
}