package de.renew.console.completer;

import java.util.List;

import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;

import de.renew.plugin.command.GetPropertyCommand;


/**
 *  This class implements the Completer interface and
 *  provides auto-completion suggestions for property names retrieved from
 *  the GetPropertyCommand. It delegates the completion logic to a StringsCompleter
 *  based on the current input buffer and cursor position.
 * @author cabac
 *
 */
public class PropertyCompleter implements Completer {

    /**
     * Constructs a new instance of the PropertyCompleter.
     * This constructor initializes the PropertyCompleter without any additional configuration.
     */
    public PropertyCompleter() {}

    /**
     * Completes the provided {@code buffer} based on the current cursor position,
     * adding potential completion candidates to the {@code candidates} list.
     *
     * @param buffer the input buffer containing the characters entered by the user so far,
     *               or {@code null} if the buffer is empty.
     * @param cursor the current position of the cursor within the buffer.
     * @param candidates a list to which the potential completion candidates will be added.
     * @return the position within the buffer where the completion suggestions apply;
     *         a negative value if no completion is available.
     */
    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        return new StringsCompleter(GetPropertyCommand.getPropertyNames())
            .complete(buffer, cursor, candidates);
    }
}