package de.renew.export.io.exportFormats;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;

import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.svg.SVGGraphics2D;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.io.api.FileApi;
import de.renew.ioontology.FileType;


/**
 * @author Benjamin Schleinzer
 *
 */
public class SVGExportFormat extends AbstractDrawingExportFormat {
    // Attributes
    // Constructor

    /**
     * Creates new SVGExportFormat trough ExportFormatAbstract.
     */
    public SVGExportFormat() {
        super("SVG", FileApi.createExtensionFileFilter(FileType.SVG));
    }

    // Methods


    @Override
    public boolean canExportNto1() {
        return false;
    }

    @Override
    public File export(Drawing drawing, File path) throws Exception {
        File result = null;

        // JPanel drawingPanel;
        // DrawApplication app = DrawPlugin.getGui();
        // if (app != null){
        //   drawingPanel = (JPanel) app.getView(drawing);
        // } else {
        //   drawingPanel = new StandardDrawingView(null, drawing);
        // }
        Rectangle r = drawing.displayBox();
        Dimension d = new Dimension(r.width, r.height);
        VectorGraphics graphics = new SVGGraphics2D(path, d);


        final UserProperties defaultProperties = new UserProperties();

        defaultProperties.setProperty(SVGGraphics2D.EMBED_FONTS, true);
        graphics.setProperties(defaultProperties);

        //Start exporting image to SVG
        graphics.startExport();

        //Move to coordinates 0,0 
        graphics.translate(r.x * -1, r.y * -1);

        //Paint the picture
        //drawingPanel.print(graphics);
        drawing.draw(graphics);

        //End exporting
        graphics.endExport();

        result = path;
        assert (result != null) : "Failure in EPSExportFormat: result == null";
        return result;
    }

    @Override
    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in EPSExportFormat: result == null";
        return result;
    }

    @Override
    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        result = true;
        return result;
    }
}