/*
 * Created on Sep 13, 2005
 *
 */

package de.renew.fa;

import java.awt.Color;
import java.util.HashSet;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.framework.FilterContainer;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FAWordTextFigure;
import de.renew.gui.CPNDrawing;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.simulator.api.SimulatorExtensions;
import de.renew.simulatorontology.shadow.ShadowCompilationResult;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.SimulatorExtension;


/**
 * This {@link Drawing} is a container of arbitrary figures, but it
 * only supports functionality for finite automaton constructs.
 */
public class FADrawing extends CPNDrawing implements LayoutableDrawing {
    static final long serialVersionUID = -4229673070089970973L;
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(FADrawing.class);

    /**
     * Container for fa {@link java.io.FileFilter}.
     */
    private static FilterContainer _filterContainer;

    private FAWordTextFigure _word;

    private FAWordTextFigure _dataStructureTextFigure;

    /**
     * Gets the {@link java.io.FileFilter}s of FADrawings.
     *
     * @return  the FileFilter for FADrawings
     */
    static public FilterContainer getFilterContainer() {
        if (_filterContainer == null) {
            return new FilterContainer(
                DrawingTypeManager.getInstance().getFilter(FAPlugin.FA_FILEFILTER));
        } else {
            return _filterContainer;
        }
    }

    /**
     * Constructs an empty FADrawing.
     */
    public FADrawing() {
        super();
        SimulatorExtensions.addExtension(new SimulatorExtension() {
            @Override
            public void simulationSetup(SimulationEnvironment env) {
                if (_word != null) {
                    _word.setColorForSimulation();
                }
            }

            @Override
            public void netsCompiled(ShadowCompilationResult result) {

            }

            @Override
            public void simulationTerminated() {
                _dataStructureTextFigure = null;
                if (_word != null) {
                    _word.setNormalColor();
                }
            }

            @Override
            public void simulationTerminating() {
                if (_word != null) {
                    _word.setNormalColor();
                }
            }
        });
    }

    @Override
    synchronized public void fillInGraph(GraphLayout layout) {
        LOGGER.debug("fillInGraph(GraphLayout) called with " + layout);
        FigureEnumeration k = figures();

        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();

            // if (f instanceof TransitionFigure || f instanceof PlaceFigure) {
            if (f instanceof FAStateFigure
                || (f instanceof TextFigure && ((TextFigure) f).parent() == null)) {
                layout.addNode(f);

                // } else if (f instanceof ArcConnection) {
            } else if (f instanceof ConnectionFigure) {
                layout.addEdge((ConnectionFigure) f, 20);
            }
            LOGGER.debug("added " + f);
        }
    }

    @Override
    public String getDefaultExtension() {
        return getDefaultFileFilter().getExtension();
    }

    @Override
    public ExtensionFileFilter getDefaultFileFilter() {
        return getFilterContainer().getDefaultFileFilter();
    }

    @Override
    public HashSet<ExtensionFileFilter> getExportFileFilters() {
        return getFilterContainer().getExportFileFilters();
    }

    @Override
    public HashSet<ExtensionFileFilter> getImportFileFilters() {
        return getFilterContainer().getImportFileFilters();
    }

    @Override
    public String getWindowCategory() {
        return "Finite Automata";
    }

    @Override
    public Figure add(Figure figure) {
        if (figure instanceof FAWordTextFigure w) {
            _word = w;
        }
        return super.add(figure);
    }

    /**
     * Initialises a new read-only text representing the data structure
     * needed to simulate the current automata type.
     */
    public void initializeDataStructureText() {
        _dataStructureTextFigure = new FAWordTextFigure();
        _dataStructureTextFigure.setReadOnly(true);
        _dataStructureTextFigure.setTextColor(Color.BLACK);
        _dataStructureTextFigure.setAttribute("FontSize", 20);
    }

    /**
     * Returns the current data structure representation held by this drawing as a {@link FAWordTextFigure}.
     * @return the current data structure text representation as a {@link FAWordTextFigure}
     */
    public FAWordTextFigure getDataStructureText() {
        return _dataStructureTextFigure;
    }
}