/*
 * Created on Feb 3, 2005
 *
 */

package de.renew.fa;

import java.util.Vector;

import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.plugin.command.CLCommand;


/**
 * Provides an interface to extend the FAPlugin with additional commands.
 *
 * @author cabac
 */
public interface FAPluginExtender {
    /**
     * Returns a list of Commands - made available by the plugin - that can be
     * added to the Menu of the plugee.
     * @return a vector of Command objects
     */
    Vector<AbstractCommand> getMenuCommands();

    /**
     * Returns Prompt (Command Line) Commands that offer functionality of the
     * plugin to the plugee. The plugee can offer this functionality to the user
     * on the prompt.
     * @return a vector of CLCommand objects
     */
    Vector<CLCommand> getPromptCommands();
}