package de.renew.fa;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.util.Palette;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.Tool;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAFigureCreationTool;
import de.renew.fa.figures.FALoopArcConnectionCreationTool;
import de.renew.fa.figures.FATextFigure;
import de.renew.fa.figures.FATextFigureCreationTool;
import de.renew.fa.figures.FAWordTextFigure;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;


/**
 * This is a creator for <i>one</i> tool {@link Palette} which uses
 * the Matthias Jantzen style for state representation.
 *
 * <p> For creating the tool with international state representation,
 * make use of the {@link AltPaletteCreator}. </p>
 *
 * <p> The palette uses images taken from <code>/de/renew/fa/images/</code>
 * </p>
 *
 * {@link CH.ifa.draw.util.Palette}
 * {@link  AltPaletteCreator}
 */
public class PaletteCreator {
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(PaletteCreator.class);

    /**
     * The signifier of this PaletteCreator.
     */
    private String _label;

    /**
     * The palette that holds the tool buttons that is created by this.
     */
    Palette _palette;

    /**
     * Constructs a PaletteCreator object that instantly creates a tool palette
     * named with the given name.
     *
     * @param name  the palettes name
     */
    public PaletteCreator(String name) {
        createPalette(name);
    }

    /**
     * Creates a Palette containing the following tools represented by buttons:
     * <ul>
     *          <li> FA Start State
     *          <li> FA State
     *          <li> FA End State
     *          <li> FA StartEnd State
     *          <li> FA Name
     *          <li> FA Inscription
     *          <li> FA Arc
     *          <li> FA Loop
     *          <li> FA Word
     * </ul>
     *
     * @param paletteName  the palettes name
     */
    protected void createPalette(String paletteName) {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            LOGGER.error("No GuiPlugin available");
            return;
        }

        // setup palette for adding tools
        String images = "/de/renew/fa/images/";
        Tool tool;
        PaletteHolder paletteHolder = starter.getPaletteHolder();
        _palette = new Palette(paletteName);
        DrawingEditor editor = starter.getDrawingEditor();


        //TODO: create new icons and add them to this plugin's file tree. Currently, all tool icons are located within CPNApplication
        // add state tools
        tool = new FAFigureCreationTool(editor, new StartDecoration());
        _palette.add(
            paletteHolder.createToolButton(images + "fa_state_s", "FA Start State Tool", tool));

        tool = new FAFigureCreationTool(editor);
        _palette.add(paletteHolder.createToolButton(images + "fa_state", "FA State Tool", tool));

        tool = new FAFigureCreationTool(editor, new EndDecoration());
        _palette
            .add(paletteHolder.createToolButton(images + "fa_state_e", "FA End State Tool", tool));

        tool = new FAFigureCreationTool(editor, new StartEndDecoration());
        _palette.add(
            paletteHolder
                .createToolButton(images + "fa_state_se", "FA Start End State Tool", tool));

        // add text tools
        FATextFigure prototype = FATextFigure.NAME;
        prototype.setAlignment(TextFigure.CENTER);
        tool = new ConnectedTextTool(editor, prototype);
        _palette.add(
            paletteHolder
                .createToolButton(CPNApplication.CPNIMAGES + "NAME", "FA Name Tool", tool));

        prototype = FATextFigure.INSCRIPTION;
        prototype.setAlignment(TextFigure.CENTER);
        tool = new FATextFigureCreationTool(
            editor, prototype, FATextFigureCreationTool.FA_TOOL_TYPE_INSCRIPTION);
        _palette.add(
            paletteHolder
                .createToolButton(CPNApplication.CPNIMAGES + "INSCR", "FA Inscription Tool", tool));

        FAWordTextFigure word = new FAWordTextFigure();
        word.setAlignment(TextFigure.CENTER);
        tool =
            new FATextFigureCreationTool(editor, word, FATextFigureCreationTool.FA_TOOL_TYPE_WORD);
        _palette.add(
            paletteHolder.createToolButton(
                "de/renew/fa/images/" + "fa_word", "FA Word Placement Tool", tool));

        // add arc tools
        FAArcConnection arc =
            new FAArcConnection(null, new ArrowTip(), AttributeFigure.LINE_STYLE_NORMAL);
        Object spline = Integer.valueOf(PolyLineFigure.BSPLINE_SHAPE);
        arc.setAttribute("LineShape", spline);
        tool = new ConnectionTool(editor, arc);
        _palette.add(
            paletteHolder
                .createToolButton("/de/renew/gui/images/" + "ARC", "FA ArcConnection Tool", tool));

        tool = new FALoopArcConnectionCreationTool(editor);
        _palette.add(
            paletteHolder.createToolButton(images + "fa_loop", "FA Loop ArcConnection Tool", tool));


        paletteHolder.addPalette(_palette);

    }

    /**
     * Label of PaletteCreation
     *
     * @return returns the label of the PaletteCreator but is always null
     * because it is never assigned
     */
    public String getLabel() {
        return _label;
    }

    /**
     * Removes this objects palette form the tools panel.
     *
     * {@link  PaletteHolder}
     */
    public void remove() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            return;
        }
        starter.getPaletteHolder().removePalette(_palette);
    }

    @Override
    public String toString() {
        return getLabel();
    }
}