package de.renew.fa.commands;

import CH.ifa.draw.util.Command;
import de.renew.fa.gui.FACompareGui;


/**
 * The command that is executed for showing the comparator window.
 */
public class ShowComparatorCommand extends Command {

    private final FACompareGui _comparatorGui;

    /**
     * Creates the comparator window.
     *
     * @param comparatorGui Instance of FACompareGui
     */
    public ShowComparatorCommand(FACompareGui comparatorGui) {
        super("FA Comparator");
        this._comparatorGui = comparatorGui;
    }

    /**
     * Shows the FAComparatorGui.
     * {@link Command#execute()}
     */
    @Override
    public void execute() {
        _comparatorGui.showGui();
    }
}