package de.renew.fa.gui;

import de.renew.faformalism.util.FAAutomatonModelEnum;


/**
 * Implementations of this interface will be used by the user to select properties (such as the automaton model),
 * enter words the automaton should simulate, or display the result of the simulation.
 */
public interface FASimulationSettingsInterface {

    /**
     * Returns the automaton type that was selected by the user.
     * @return one of {@link FAAutomatonModelEnum}
     */
    FAAutomatonModelEnum getSelectedAutomatonType();

    /**
     * Checks if the user selected to simulate a specific word, or if the word was to be built
     * through the simulation.
     * @return true, if the user wants to simulate a specific word; false otherwise
     */
    boolean simulateWordMode();

    /**
     * If the gui is not visible or does not have focus, this method will show the gui and put it in focus.
     */
    void showGui();

    /**
     * Clears the interface implementation.
     */
    void cleanup();
}
