/*
 * Created on Aug 1, 2005
 *
 */

package de.renew.fa.model;


/**
 * @author cabac
 *
 */
public class WordImpl implements Word {
    private String _name;

    /**
     * Constructs a default empty word.
     */
    public WordImpl() {
        _name = "";
    }

    /**
     * Creates a word for a given token.
     *
     * @param token the token that represents the word
     */
    public WordImpl(String token) {
        _name = token;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Word) {
            Word word = (Word) obj;
            return this.getName().equals(word.getName());
        }
        return false;
    }

    @Override
    public String getName() {
        return _name;
    }

    @Override
    public boolean isEmpty() {
        if ("".equals(getName())) {
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "" + _name;
    }

    @Override
    public int hashCode() {
        return _name.hashCode();
    }
}